#ifndef _DEFINED_NetWorkDLS_Standard_Windows_Function_Library_System_Functions
#define _DEFINED_NetWorkDLS_Standard_Windows_Function_Library_System_Functions
///////////////////////////////////////////////////////////////////////////////////////////

void SetApplicationPriority(HANDLE CurrentProcessHandle, HANDLE CurrentThreadHandle, short xPriorityClass, short xThreadPriority, BOOL ProcessBoost, BOOL ThreadBoost)
{
    if(xPriorityClass == 1) SetPriorityClass(CurrentProcessHandle,IDLE_PRIORITY_CLASS);
    if(xPriorityClass == 2) SetPriorityClass(CurrentProcessHandle,NORMAL_PRIORITY_CLASS);
    if(xPriorityClass == 3) SetPriorityClass(CurrentProcessHandle,HIGH_PRIORITY_CLASS);
    if(xPriorityClass == 4) SetPriorityClass(CurrentProcessHandle,REALTIME_PRIORITY_CLASS);

    if(xThreadPriority == 1) SetThreadPriority(CurrentThreadHandle,THREAD_PRIORITY_IDLE);
    if(xThreadPriority == 2) SetThreadPriority(CurrentThreadHandle,THREAD_PRIORITY_LOWEST);
    if(xThreadPriority == 3) SetThreadPriority(CurrentThreadHandle,THREAD_PRIORITY_BELOW_NORMAL);
    if(xThreadPriority == 4) SetThreadPriority(CurrentThreadHandle,THREAD_PRIORITY_NORMAL);
    if(xThreadPriority == 5) SetThreadPriority(CurrentThreadHandle,THREAD_PRIORITY_ABOVE_NORMAL);
    if(xThreadPriority == 6) SetThreadPriority(CurrentThreadHandle,THREAD_PRIORITY_HIGHEST);
    if(xThreadPriority == 7) SetThreadPriority(CurrentThreadHandle,THREAD_PRIORITY_TIME_CRITICAL);

    if(ProcessBoost == 0) SetProcessPriorityBoost(CurrentProcessHandle,TRUE); //Disable
    if(ProcessBoost == 1) SetProcessPriorityBoost(CurrentProcessHandle,FALSE); //Enable

    if(ThreadBoost == 0) SetThreadPriorityBoost(CurrentThreadHandle,TRUE); //Disable
    if(ThreadBoost == 1) SetThreadPriorityBoost(CurrentThreadHandle,FALSE); //Enable
}

///////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_FileSize(char *File2Size)
{
    HANDLE FileHandle = NULL;
    DWORD Size = 0;
//    FileHandle = CreateFile(File2Size, GENERIC_READ, FILE_SHARE_READ, NULL, OPEN_EXISTING, 0, NULL);
    FileHandle = CreateFile(File2Size, 0, 0, NULL, OPEN_EXISTING, 0, NULL);
    Size = GetFileSize(FileHandle, NULL);
    CloseHandle(FileHandle);
    if(Size == HFILE_ERROR)
        return (DWORD) -1;
    return Size;
}

///////////////////////////////////////////////////////////////////////////////////////////

bool IsDirectory(char *xRequest)
{
    int Attrib = 0;
    Attrib = GetFileAttributes(xRequest);
    if(Attrib != 0xFFFFFFFF)
    {
        if(Attrib & FILE_ATTRIBUTE_DIRECTORY)
            return true;
    }
    return false;
}

///////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_CurrentDirectoryEx (char *ReturnValue)
{
    return GetCurrentDirectory(256, ReturnValue);
}

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_CurrentDirectory (void)
{
    char *Name = (char *) calloc(256,1);
    Get_CurrentDirectoryEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_TempDirectoryEx (char *ReturnValue)
{
    return GetTempPath(256, ReturnValue);
}

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_TempDirectory (void)
{
    char *Name = (char *) calloc(256,1);
    Get_TempDirectoryEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_WindowsDirectoryEx (char *ReturnValue)
{
    return GetWindowsDirectory(ReturnValue, 256);
} 

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_WindowsDirectory (void)
{
    char *Name = (char *) calloc(256,1);
    Get_WindowsDirectoryEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////

DWORD Get_SystemDirectoryEx (char *ReturnValue)
{
    return GetSystemDirectory(ReturnValue,256);
}

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_SystemDirectory (void)
{
    char *Name = (char *) calloc(256,1);
    Get_SystemDirectoryEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////

int Get_TimeEx (char *ReturnValue)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);
    return GetTimeFormat(LOCALE_USER_DEFAULT,TIME_NOSECONDS,&ST,NULL,ReturnValue,64);
}

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_Time (void)
{
    char *TimeTemp = (char *) calloc(256,1);
    Get_TimeEx(TimeTemp);
    return TimeTemp;
}

///////////////////////////////////////////////////////////////////////////////////////////

int Get_LongDateEx (char *ReturnValue)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);
    return GetDateFormat(LOCALE_USER_DEFAULT,DATE_LONGDATE,&ST,NULL,ReturnValue,64);
}

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_LongDate (void)
{
    char *DateTemp = (char *) calloc(256,1);
    Get_LongDateEx(DateTemp);
    return DateTemp;
}

///////////////////////////////////////////////////////////////////////////////////////////

int Get_ShortDateEx (char *ReturnValue)
{
    SYSTEMTIME ST;
    GetLocalTime(&ST);
    return GetDateFormat(NULL,NULL,&ST,"MM-dd-yyyy",ReturnValue,64);
}

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_ShortDate (void)
{
    char *DateTemp = (char *) calloc(256,1);
    Get_ShortDateEx(DateTemp);
    return DateTemp;
}

///////////////////////////////////////////////////////////////////////////////////////////

BOOL Get_MachineNameEx (char *ReturnValue)
{
    DWORD SizeOfName = 256;
    return GetComputerName(ReturnValue, &SizeOfName);
}

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_MachineName (void)
{
    char *Name = (char *) calloc(256, 1);
    Get_MachineNameEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////

BOOL Get_UserNameEx (char *ReturnValue)
{
    DWORD SizeOfName = 256;
    return GetUserName(ReturnValue, &SizeOfName);
}

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
char * Get_UserName (void)
{
    char *Name = (char *) calloc(256,1);
    Get_UserNameEx(Name);
    return Name;
}

///////////////////////////////////////////////////////////////////////////////////////////

// This functions return value must be freed externally
void Get_OsVersionEx (char *ReturnValue)
{
    DWORD dwVersion = 0;
    OSVERSIONINFO OS;
    OS.dwOSVersionInfoSize = sizeof(OS);
    dwVersion = GetVersion();

    if(GetVersionEx(&OS))
    {
        if(OS.dwPlatformId == 1)
        {
            if(OS.dwMinorVersion == 0)
                sprintf(ReturnValue, "Windows 95 %d.%d (Build %d) %s",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
            if(OS.dwMinorVersion == 10)
                sprintf(ReturnValue, "Windows 98 %d.%d (Build %d) %s",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
            if(OS.dwMinorVersion == 90)
                sprintf(ReturnValue, "Windows ME %d.%d (Build %d) %s",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
        }

        if(OS.dwPlatformId == 2)
        {
            if(OS.dwMajorVersion == 3)
                sprintf(ReturnValue, "Windows NT %d.%d (Build %d) %s",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
            if(OS.dwMajorVersion == 4)
                sprintf(ReturnValue, "Windows NT %d.%d (Build %d) %s",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
            if(OS.dwMajorVersion == 5 && OS.dwMinorVersion == 0)
                sprintf(ReturnValue, "Windows 2000 %d.%d (Build %d) %s",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
            if(OS.dwMajorVersion == 5 && OS.dwMinorVersion == 1)
                sprintf(ReturnValue, "Windows XP %d.%d (Build %d) %s",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
            if(OS.dwMajorVersion == 5 && OS.dwMinorVersion == 2)
                sprintf(ReturnValue, "Windows .NET %d.%d (Build %d) %s",LOBYTE(LOWORD(dwVersion)),HIBYTE(LOWORD(dwVersion)),OS.dwBuildNumber & 0xFFFF,OS.szCSDVersion);
        }
    }
}

///////////////////////////////////////////////////////////////////////////////////////////

char * Get_OsVersion (void)
{
    char *ReturnValue = (char *) calloc(256,1);
    Get_OsVersionEx(ReturnValue);
    return ReturnValue;
}

///////////////////////////////////////////////////////////////////////////////////////////

bool IsWinNT(void)
{
    OSVERSIONINFO osv;
    osv.dwOSVersionInfoSize = sizeof(osv);
    GetVersionEx(&osv);
    return( osv.dwPlatformId == VER_PLATFORM_WIN32_NT );
}

///////////////////////////////////////////////////////////////////////////////////////////
#endif

